
/* this is just a basic stepper control, will recive
 instructions from the camera, which will host the main server
*/
#include <Arduino.h>
#include <WiFi.h>
#include <Stepper.h>
#include <ESPmDNS.h>

// Stepper Motor Settings
const int stepsPerRevolution = 200;  // change this to fit the number of steps per revolution
#define DIR 0
#define STEP 1

int movedsteps = 0;
const char* ssid = "EngineeringStudent";
const char* password = "cls2024!";
const char* networkname = "maestro2";
String steps;

WiFiServer server(80);
void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("Connecting to WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }
  if (!MDNS.begin(networkname)) {  // Set the hostname to "esp32.local"
    Serial.println("Error setting up MDNS responder! freezing program execution");
    while (1) {
      delay(500);
    }
  }
  Serial.println(WiFi.localIP());
  pinMode(STEP, OUTPUT);
  pinMode(DIR, OUTPUT);
  Serial.println("");
  Serial.print(networkname);
  Serial.print(".local");
  server.begin();
  delay(250);
}

void handleGetRequest(WiFiClient& client) {
  Serial.println("client got");
  client.print("HTTP/1.1 200 OK\r\n");
  client.print("Access-Control-Allow-Origin: *\r\n");
  client.print("Content-Type: text/html\r\n");
  client.print("Connection: close\r\n\r\n");
  client.print("hi");
}

void handlePostRequest(WiFiClient& client, String request) {
  String body = "";
  Serial.println("post request received.");
  // Read the body after headers
  while (client.available()) {
    char c = client.read();
    body += c;
  }
  Serial.println(body);
  // Extract 'steps' parameter
  if (body.indexOf("name=\"steps\"") != -1) {
    int start = body.indexOf("name=\"steps\"") + 4;  // Move past 'name="left"\r\n\r\n'
    start = body.indexOf("\r\n", start);          // Skip boundary
    int end = body.indexOf("\r\n", start);
    steps = body.substring(start, end).toInt();  // Convert to integer
    Serial.print("Number of left steps set to: ");
    Serial.println(steps);
  }


  // Send response
  // Send response with CORS headers
  client.print("HTTP/1.1 200 OK\r\n");
  client.print("Access-Control-Allow-Origin: *\r\n");               // Allow requests from any origin
  client.print("Access-Control-Allow-Methods: POST, OPTIONS\r\n");  // Allow POST and OPTIONS
  client.print("Access-Control-Allow-Headers: Content-Type\r\n");   // Allow custom headers like Content-Type
  client.print("Connection: close\r\n");
  client.print("\r\n");
  client.stop();
}

void loop() {
  WiFiClient client = server.available();  // Check for incoming client
  if (client) {
    Serial.println("something happen");
    String request = "";
    while (client.connected() && client.available()) {
      char c = client.read();
      request += c;
      if (c == '\n' && request.endsWith("\r\n\r\n")) {
        break;  // End of request
      }
    }

    if (request.startsWith("GET /")) {
      handleGetRequest(client);
    } else if (request.startsWith("POST /")) {
      handlePostRequest(client, request);
    }
  }
  delay(25);
}